@extends('admin.layout.template')

@section('title','Add Role')

@section('content')

<div class="page-content">
    <div class="container-xxl">

        <form method="POST" action="{{ route('roles.store') }}">
            @csrf

            {{-- Role Info --}}
            <div class="card mb-4">
                <div class="card-header">
                    <h4>Create Role</h4>
                </div>
                <div class="card-body row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Role Name</label>
                        <input type="text" name="role_name" class="form-control" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Departments</label>
                        <select name="department_ids[]" class="form-control" multiple data-choices required>
                            @foreach($departments as $dept)
                            <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-12 mt-2">
                        <div class="form-check">
                            <input type="checkbox" name="is_locked" class="form-check-input" id="is_locked">
                            <label class="form-check-label" for="is_locked">Lock this role (System Role)</label>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
    <div class="card-header">
        <h5 class="mb-0">Role Permissions</h5>
    </div>

    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-bordered align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th style="width:180px">Module</th>
                        <th class="text-center">View</th>
                        <th class="text-center">Add</th>
                        <th class="text-center">Edit</th>
                        <th class="text-center">Delete</th>
                        <th class="text-center">Approve</th>
                    </tr>
                </thead>
                <tbody>

                    @foreach($permissions as $module => $actions)
                        <tr>
                            <td class="fw-semibold text-capitalize">
                                {{ str_replace('_',' ', $module) }}
                            </td>

                            {{-- View --}}
                            <td class="text-center">
                                @isset($actions['view'])
                                    <input type="checkbox"
                                           name="permissions[]"
                                           value="{{ $actions['view'] }}">
                                @endisset
                            </td>

                            {{-- Add --}}
                            <td class="text-center">
                                @isset($actions['add'])
                                    <input type="checkbox"
                                           name="permissions[]"
                                           value="{{ $actions['add'] }}">
                                @endisset
                            </td>

                            {{-- Edit --}}
                            <td class="text-center">
                                @isset($actions['edit'])
                                    <input type="checkbox"
                                           name="permissions[]"
                                           value="{{ $actions['edit'] }}">
                                @endisset
                            </td>

                            {{-- Delete --}}
                            <td class="text-center">
                                @isset($actions['delete'])
                                    <input type="checkbox"
                                           name="permissions[]"
                                           value="{{ $actions['delete'] }}">
                                @endisset
                            </td>

                            {{-- Approve --}}
                            <td class="text-center">
                                @isset($actions['approve'])
                                    <input type="checkbox"
                                           name="permissions[]"
                                           value="{{ $actions['approve'] }}">
                                @endisset
                            </td>
                        </tr>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>


<div class="card mt-4">
    <div class="card-header">
        <h5 class="mb-0">Data Access Scope</h5>
    </div>

    <div class="card-body">
        @foreach($permissions as $module => $actions)

            <div class="row mb-3 align-items-center">
                <div class="col-md-3 fw-semibold text-capitalize">
                    {{ str_replace('_',' ', $module) }}
                </div>

                <div class="col-md-3">
                    <select name="scopes[{{ $module }}][scope_type]"
                            class="form-select scope-type"
                            data-module="{{ $module }}">
                        <option value="none">No Access</option>
                        <option value="own">Own</option>
                        <option value="department">Department</option>
                        <option value="location">Location</option>
                        <option value="all">All</option>
                    </select>
                </div>

                <div class="col-md-6 scope-values d-none"
                     id="scope-values-{{ $module }}">

                    {{-- Departments --}}
                    <select name="scopes[{{ $module }}][scope_value][]"
                            class="form-control" multiple data-choices>
                        @foreach($departments as $dept)
                            <option value="{{ $dept->id }}">
                                {{ $dept->name }}
                            </option>
                        @endforeach
                    </select>

                </div>
            </div>

        @endforeach
    </div>
</div>

          

            <div class="text-end mb-5">
                <button type="submit" class="btn btn-primary">Save Role</button>
            </div>
        </form>
    </div>
</div>

<script>
    // Select All permissions
    document.querySelectorAll('.select-all').forEach(el => {
        el.addEventListener('change', function() {
            document.querySelectorAll('.module-' + this.dataset.module)
                .forEach(cb => cb.checked = this.checked);
        });
    });

    // Data Scope switcher
    // document.querySelectorAll('.scope-type').forEach(select => {
    //     select.addEventListener('change', function() {
    //         const module = this.dataset.module;
    //         const val = this.value;
    //         document.querySelectorAll(`[id^="scope-"][id$="-${module}"]`).forEach(el => el.classList.add('d-none'));
    //         if (!['all', 'own_only'].includes(val)) {
    //             const target = document.getElementById('scope-' + val + '-' + module);
    //             if (target) target.classList.remove('d-none');
    //         }
    //     });
    // });
</script>

<script>
document.addEventListener('change', function (e) {
    if (!e.target.classList.contains('scope-type')) return;

    const module = e.target.dataset.module;
    const wrapper = document.getElementById(`scope-values-${module}`);

    if (['department', 'location'].includes(e.target.value)) {
        wrapper.classList.remove('d-none');
    } else {
        wrapper.classList.add('d-none');
    }
});
</script>

@endsection